do_niche_neutral_local_comm <- function(n_star,J_M,nu,J,m)
  {
  S = 0
  for ( i in 1:n_star )
    {
    comm = do_neutral_local_comm(J_M/n_star,nu,J/n_star,m)
    S = S + tail(comm$Ss,1)
    } 
  return(S)
  }
 
  
n_star = 10 # number of niches
J_M = 10000 # size of metacommunity
nu = 0.001 # speciation rate
J = 1000 # size of local community
ms = 10^seq(-5,-1) # immigration rates
Ss = numeric(length(ms)) # vector for species richness

# run one simulation for each immigration rate
for ( j in 1:length(ms) )
  {
  m = ms[j]
  Ss[j] = do_niche_neutral_local_comm(n_star,J_M,nu,J,m)
  }

plot(ms,Ss,type='l',log='x',ylim=c(0,max(Ss)),xlab='m',
     ylab='S') 
